<?php

// TODO: Admin
use App\Http\Controllers\Backend\AboutUsController;
use App\Http\Controllers\Backend\SpinSettingController;
use App\Http\Controllers\Backend\ServiceController;
use App\Http\Controllers\Backend\GoogleAdController;
use App\Http\Controllers\Backend\PolicyController;
use App\Http\Controllers\Backend\PremiumPackageController;
use App\Http\Controllers\Backend\UserVerifyDocumentController;
use App\Http\Controllers\Backend\LotteryController;
use App\Http\Controllers\Backend\CategoryController;
use App\Http\Controllers\Backend\SubCategoryController;
use App\Http\Controllers\Backend\BoostChargeController;
use App\Http\Controllers\Backend\BoostCategoryController;
use App\Http\Controllers\Backend\BoostSubCategoryController;
use App\Http\Controllers\Backend\UserBoostPackageController;
use App\Http\Controllers\Backend\ContinentController;
use App\Http\Controllers\Backend\CountryController;
use App\Http\Controllers\Backend\LocationZoneController;
use App\Http\Controllers\Backend\LocationZoneCountryController;
use App\Http\Controllers\Backend\HeadlineController;
use App\Http\Controllers\Backend\AcceptTaskHeadlineController;
use App\Http\Controllers\Backend\CompleteTaskHeadlineController;
use App\Http\Controllers\Backend\DepositTaskHeadlineController;
use App\Http\Controllers\Backend\DepositDocumentController;
use App\Http\Controllers\Backend\WithdrawTaskHeadlineController;
use App\Http\Controllers\Backend\BoostPackageHeadlineController;
use App\Http\Controllers\Backend\TopDepositUserHeadlineController;
use App\Http\Controllers\Backend\TopEarningUserHeadlineController;
use App\Http\Controllers\Backend\TopReferralUserHeadlineController;
use App\Http\Controllers\Backend\UserMessageController;
use App\Http\Controllers\Backend\DefaultController;
use App\Http\Controllers\Backend\WelcomeBonusController;
use App\Http\Controllers\Backend\DollarRateController;
use App\Http\Controllers\Backend\DepositAccountController;
use App\Http\Controllers\Backend\WithdrawMethodController;
use App\Http\Controllers\Backend\WithdrawController;
use App\Http\Controllers\Backend\AdvertisementController;
use App\Http\Controllers\Backend\AdvertisementRateController;
use App\Http\Controllers\Backend\JobController;
use App\Http\Controllers\Backend\JobWorkController;
use App\Http\Controllers\Backend\ModuleController;
use App\Http\Controllers\Backend\PaidAdRateController;

use App\Http\Controllers\Backend\ContactUsTextController;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Backend\ProfileController;
use App\Http\Controllers\Backend\RoleController;
use App\Http\Controllers\Backend\ClientController;
use App\Http\Controllers\Backend\UserController;
use App\Http\Controllers\Backend\UserSettingController;
use App\Http\Controllers\Backend\ScriptForSiteController;
use App\Http\Controllers\Backend\WebsiteController;
use App\Http\Controllers\Backend\referredDistibuttion;

use App\Http\Controllers\ContactMessageController;
use app\Http\Controllers\PaymentController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ReferUserController;
use GuzzleHttp\Middleware;
use Illuminate\Support\Facades\Auth;

// TODO:: User
use App\Http\Controllers\User\UserDashboardController;
use App\Http\Controllers\User\UserDepositCOntroller;
use App\Http\Controllers\User\UserAdvertisementController;
use App\Http\Controllers\User\UserWithdrawController;
use App\Http\Controllers\User\UserJobController;
use App\Http\Controllers\User\UserProfileController;
use App\Http\Controllers\User\UserJobWorkController;
use App\Http\Controllers\User\BoostPackageController;
use App\Http\Controllers\User\UserSpinController;
use App\Http\Controllers\User\UserReferralController;
use App\Http\Controllers\User\UserLotteryController;
// TODO:: Frontend
use Illuminate\Support\Facades\Route;

Auth::routes();

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/home', [HomeController::class, 'index']);
Route::get('/app-config', [HomeController::class, 'app_config']);
Route::get('/postback-timewall', [HomeController::class, 'postback_timewall']);
Route::get('/about', [HomeController::class, 'about_us'])->name('about-us');

Route::get('/referral-program', [HomeController::class, 'referralProgram'])->name('referral-program');
Route::get('/spin', [HomeController::class, 'spin'])->name('spin');
Route::get('/mine', [UserDepositCOntroller::class, 'mine'])->name('mine');
Route::get('/membership', [UserDashboardController::class, 'premium'])->name('membership');
Route::get('/notice-board', [HomeController::class, 'noticeBoard'])->name('notice-board');
Route::get('/faq', [HomeController::class, 'faq'])->name('faq');

Route::get('/service', [HomeController::class, 'service'])->name('service');
Route::get('/service/{slug}', [HomeController::class, 'service_details'])->name('service_details');
Route::get('/policy-details/{slug}', [HomeController::class, 'policy_details'])->name('policy-details');
Route::get('/photo-gallery', [HomeController::class, 'photo_gallery'])->name('photo-gallery');
Route::get('/contact', [HomeController::class, 'contact_us'])->name('contact-us');
Route::post('/contact-message', [ContactMessageController::class, 'store'])->name('contact_message.send');
Route::get('/career', [HomeController::class, 'career'])->name('career');

Route::get('my-captcha', 'HomeController@myCaptcha')->name('myCaptcha');
Route::post('my-captcha', 'HomeController@myCaptchaPost')->name('myCaptcha.post');
Route::get('refresh_captcha', 'HomeController@refreshCaptcha')->name('refresh_captcha');

Route::get('/job/{code}', [HomeController::class, 'job_details'])->name('job-details');

// Refer user
Route::get('/refer-user/{code}', [ReferUserController::class, 'refer_user']);

// User register
Route::post('/user-register', [HomeController::class, 'user_register'])->name('user-register');
Route::post('/refer-user-register', [HomeController::class, 'refer_user_register'])->name('refer-user-register');
Route::post('/user-logout', [HomeController::class, 'user_logout'])->name('user-logout');

Route::get('/user-foreget-password', [HomeController::class, 'foreget_password'])->name('user-foreget-password');
Route::post('/recover-password', [HomeController::class, 'recover_password'])->name('recover-password');

// Admin login
Route::get('/admin-login', [HomeController::class, 'admin_login']);

Route::get('/reload-captcha', [HomeController::class, 'reload_captcha']);

// TODO: Admin routes
// Route::group(['prefix' => 'super-admin','as' => 'admin.', 'middleware'=>['auth','superadmin']], function () {
//     Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
// });

// TODO: Admin routes
Route::group(['prefix' => 'admin', 'as' => 'admin.', 'namespace' => 'Admin', 'middleware' => ['auth', 'admin']], function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/get-country', [DashboardController::class, 'get_country'])->name('get-country');
    Route::post('/get-sub-category', [DashboardController::class, 'get_sub_category'])->name('get-sub-category');

    Route::post('/get-boost-sub-category', [DashboardController::class, 'get_boost_sub_category'])->name('get-boost-sub-category');
    Route::post('/get-boost-sub-category-price', [DashboardController::class, 'get_boost_sub_category_price'])->name('get-boost-sub-category-price');

    // TODO: Role Routes
    Route::get('role', [RoleController::class, 'index'])->name('role');
    Route::post('role-store', [RoleController::class, 'store'])->name('role.store');
    Route::post('role-update-{id}', [RoleController::class, 'update'])->name('role.update');
    Route::get('role-permission/{slug}', [RoleController::class, 'role_permission'])->name('role-permission');
    Route::post('role-permission-update', [RoleController::class, 'role_permission_update'])->name('role-permission-update');

    // TODO:User Routes
    Route::get('user', [UserController::class, 'index'])->name('user');
    Route::get('verified-user', [UserController::class, 'verified_user'])->name('verified-user');
    Route::get('unverified-user', [UserController::class, 'unverified_user'])->name('unverified-user');
    Route::get('user-search', [UserController::class, 'user_search'])->name('user-search');
    Route::get('admin-user', [UserController::class, 'admin_user'])->name('admin-user');
    Route::post('user-store', [UserController::class, 'store'])->name('user.store');
    Route::get('user-edit-{id}', [UserController::class, 'edit'])->name('user.edit');
    Route::get('admin-user-edit-{id}', [UserController::class, 'edit'])->name('admin-user.edit');
    Route::post('user-update-{id}', [UserController::class, 'update'])->name('user.update');
    Route::post('user-balance-update-{id}', [UserController::class, 'user_balance'])->name('user-balance.update');
    Route::post('user-activity-update-{id}', [UserController::class, 'user_activity'])->name('user-activity.update');
    Route::post('user-verification-update-{id}', [UserController::class, 'user_verification'])->name('user-verification.update');
    Route::get('user-delete-{id}', [UserController::class, 'destroy'])->name('user.delete');
    Route::post('user-verify-{id}', [UserController::class, 'verify'])->name('user.verify');
    
    Route::get('premium-user', [UserController::class, 'premium_user'])->name('premium-user');
    Route::get('premium-user-search', [UserController::class, 'premium_user_search'])->name('premium-user-search');
    
    Route::get('user-document-verify', [UserController::class, 'user_document_verify'])->name('user-document-verify');
    Route::post('user-document-verify-update-{id}', [UserController::class, 'user_document_verify_update'])->name('user-document-verify.update');
    
    // Spin Setting Route
    Route::get('spin-setting', [SpinSettingController::class, 'index'])->name('spin-setting');
    Route::post('spin-setting-{id}', [SpinSettingController::class, 'update'])->name('spin-setting.update');
    
    // TODO:: About Us Routes
    Route::get('about', [AboutUsController::class, 'index'])->name('about_us');
    Route::post('about-update-{id}', [AboutUsController::class, 'update'])->name('about_us.update');
    
    Route::get('system-color-setup', [AboutUsController::class, 'system_color_setup'])->name('system-color-setup');
    Route::post('system-color-setup-update-{id}', [AboutUsController::class, 'system_color_setup_update'])->name('system-color-setup.update');
    
    Route::get('header-info', [AboutUsController::class, 'header_info'])->name('header-info');
    Route::post('header-info-update-{id}', [AboutUsController::class, 'header_info_update'])->name('header-info.update');
    
    Route::get('counter-info', [AboutUsController::class, 'counter_info'])->name('counter-info');
    Route::post('counter-info-update-{id}', [AboutUsController::class, 'counter_info_update'])->name('counter-info.update');
    
    Route::get('refer-info', [AboutUsController::class, 'refer_info'])->name('refer-info');
    Route::post('refer-info-update-{id}', [AboutUsController::class, 'refer_info_update'])->name('refer-info.update');
    
    Route::get('login-register-page-info', [AboutUsController::class, 'login_register_page_info'])->name('login-register-page-info');
    Route::post('login-register-page-info-update-{id}', [AboutUsController::class, 'login_register_page_info_update'])->name('login-register-page-info.update');

    // TODO:: Contact Us Routes
    Route::get('contact-info', [ContactUsTextController::class, 'index'])->name('contact_info');
    Route::post('contact-info-update-{id}', [ContactUsTextController::class, 'update'])->name('contact_info.update');
    Route::get('contact-message-list', [ContactUsTextController::class, 'contact_msg'])->name('contact_msg');

    // TODO: Google ad Route
    Route::get('google-ad', [GoogleAdController::class, 'index'])->name('google-ad');
    Route::post('google-ad-store', [GoogleAdController::class, 'store'])->name('google-ad.store');
    Route::post('google-ad-update-{id}', [GoogleAdController::class, 'update'])->name('google-ad.update');
    Route::get('google-ad-delete-{id}', [GoogleAdController::class, 'destroy'])->name('google-ad.delete');

    // TODO: Policy Route
    Route::get('policy', [PolicyController::class, 'index'])->name('policy');
    Route::post('policy-store', [PolicyController::class, 'store'])->name('policy.store');
    Route::post('policy-update-{id}', [PolicyController::class, 'update'])->name('policy.update');
    Route::get('policy-delete-{id}', [PolicyController::class, 'destroy'])->name('policy.delete');

    // TODO: PremiumPackageController Route
    Route::get('premium-package', [PremiumPackageController::class, 'index'])->name('premium-package');
    Route::post('premium-package-store', [PremiumPackageController::class, 'store'])->name('premium-package.store');
    Route::post('get-premium-package-for-update', [PremiumPackageController::class, 'get_premium_package_for_update'])->name('get-premium-package-for-update');
    Route::post('premium-package-update-{id}', [PremiumPackageController::class, 'update'])->name('premium-package.update');
    Route::get('premium-package-delete-{id}', [PremiumPackageController::class, 'destroy'])->name('premium-package.delete');

    // TODO: Script For Site Route
    Route::get('custom-script', [ScriptForSiteController::class, 'index'])->name('custom-script');
    Route::post('custom-script-store', [ScriptForSiteController::class, 'store'])->name('custom-script.store');
    Route::post('custom-script-update-{id}', [ScriptForSiteController::class, 'update'])->name('custom-script.update');
    Route::post('custom-script-delete-{id}', [ScriptForSiteController::class, 'destroy'])->name('custom-script.delete');

    // TODO: Service Route
    Route::get('service', [ServiceController::class, 'index'])->name('service');
    Route::post('service-store', [ServiceController::class, 'store'])->name('service.store');
    Route::post('service-update-{id}', [ServiceController::class, 'update'])->name('service.update');
    Route::get('service-delete-{id}', [ServiceController::class, 'destroy'])->name('service.delete');

    // TODO: Job Routes
    Route::get('job', [JobController::class, 'index'])->name('job');
    Route::get('pending-job', [JobController::class, 'pending_job'])->name('pending-job');
    Route::get('complete-job', [JobController::class, 'complete_job'])->name('complete-job');
    Route::get('rejected-job', [JobController::class, 'rejected_job'])->name('rejected-job');
    Route::post('job-store', [JobController::class, 'store'])->name('job.store');
    Route::get('job-edit/{id}', [JobController::class, 'edit'])->name('job-edit');
    Route::post('job-update-{id}', [JobController::class, 'update'])->name('job.update');
    Route::get('job-approve/{id}', [JobController::class, 'job_approve'])->name('job-approve');
    Route::post('reject-job/{id}', [JobController::class, 'reject_job'])->name('reject-job');
    Route::get('job-delete/{id}', [JobController::class, 'destroy'])->name('job-delete');

    // TODO: Job work routes
    Route::get('job-work', [JobWorkController::class, 'index'])->name('job-work');
    Route::get('job-work-delete/{id}', [JobWorkController::class, 'destroy'])->name('job-work-delete');
    Route::get('job-work-approve/{id}', [JobWorkController::class, 'job_work_approve'])->name('job-work-approve');

    // TODO: Deposit Account Routes
    Route::get('deposit-account', [DepositAccountController::class, 'index'])->name('deposit-account');
    Route::post('deposit-account-store', [DepositAccountController::class, 'store'])->name('deposit-account.store');
    Route::get('deposit-account-edit/{id}', [DepositAccountController::class, 'edit'])->name('deposit-account.edit');
    Route::post('deposit-account-update-{id}', [DepositAccountController::class, 'update'])->name('deposit-account.update');
    Route::get('deposit-account-delete-{id}', [DepositAccountController::class, 'destroy'])->name('deposit-account.delete');

    Route::get('deposit-list', [DepositAccountController::class, 'deposit_list'])->name('deposit-list');
    Route::get('pending-deposit', [DepositAccountController::class, 'pending_deposit'])->name('pending-deposit');
    Route::post('deposit-approved/{id}', [DepositAccountController::class, 'deposit_approved'])->name('deposit-approved');
    Route::get('deposit-delete/{id}', [DepositAccountController::class, 'deposit_delete'])->name('deposit-delete');

    // TODO: Withdraw method Routes
    Route::get('withdraw-method', [WithdrawMethodController::class, 'index'])->name('withdraw-method');
    Route::post('withdraw-method-store', [WithdrawMethodController::class, 'store'])->name('withdraw-method.store');
    Route::get('withdraw-method-edit/{id}', [WithdrawMethodController::class, 'edit'])->name('withdraw-method.edit');
    Route::post('withdraw-method-update-{id}', [WithdrawMethodController::class, 'update'])->name('withdraw-method.update');
    Route::get('withdraw-method-delete-{id}', [WithdrawMethodController::class, 'destroy'])->name('withdraw-method.delete');

    // TODO: Ads rate Routes
    Route::get('ads-rate', [PaidAdRateController::class, 'index'])->name('ads-rate');
    Route::post('ads-rate-store', [PaidAdRateController::class, 'store'])->name('ads-rate.store');
    Route::post('ads-rate-update-{id}', [PaidAdRateController::class, 'update'])->name('ads-rate.update');

    // TODO: Ads rate Routes
    Route::get('advertisement-rate', [AdvertisementRateController::class, 'index'])->name('advertisement-rate');
    Route::post('advertisement-rate-store', [AdvertisementRateController::class, 'store'])->name('advertisement-rate.store');
    Route::post('advertisement-rate-update-{id}', [AdvertisementRateController::class, 'update'])->name('advertisement-rate.update');
    Route::get('advertisement-rate-delete/{id}', [AdvertisementRateController::class, 'destroy'])->name('advertisement-rate.delete');

    // TODO: Module Routes
    Route::get('module', [ModuleController::class, 'index'])->name('module');
    Route::post('module-update-{id}', [ModuleController::class, 'update'])->name('module.update');

    Route::get('withdraw-request', [WithdrawController::class, 'index'])->name('withdraw-request');
    Route::get('pending-withdraw-request', [WithdrawController::class, 'pending_withdraw_request'])->name('pending-withdraw-request');
    Route::post('withdraw-request-approved/{id}', [WithdrawController::class, 'withdraw_request_approved'])->name('withdraw-request-approved');
    Route::get('withdraw-request-delete/{id}', [WithdrawController::class, 'destroy'])->name('withdraw-request-delete');

    // TODO: Deposit Account Routes
    Route::get('advertisement', [AdvertisementController::class, 'index'])->name('advertisement');
    Route::get('pending-advertisement', [AdvertisementController::class, 'pending_advertisement'])->name('pending-advertisement');
    Route::get('expired-advertisement', [AdvertisementController::class, 'expired_advertisement'])->name('expired-advertisement');
    Route::post('advertisement-store', [AdvertisementController::class, 'store'])->name('advertisement.store');
    Route::post('advertisement-update-{id}', [AdvertisementController::class, 'update'])->name('advertisement.update');
    Route::post('advertisement-delete-{id}', [AdvertisementController::class, 'destroy'])->name('advertisement.delete');
    Route::post('advertisement-approve-{id}', [AdvertisementController::class, 'approve'])->name('advertisement.approve');
    Route::post('advertisement-exp-date-{id}', [AdvertisementController::class, 'exp_dade_update'])->name('advertisement-exp-dade.update');
    
    Route::get('click-earn-ads', [AdvertisementController::class, 'click_earn_ads'])->name('click-earn-ads');
    Route::get('click-earn-ads-delete/{id}', [AdvertisementController::class, 'click_earn_ads_delete'])->name('click-earn-ads-delete');

    // TODO: Verify Document Routes
    Route::get('verify-document', [UserVerifyDocumentController::class, 'index'])->name('verify-document');
    Route::post('verify-document-store', [UserVerifyDocumentController::class, 'store'])->name('verify-document.store');
    Route::post('verify-document-update-{id}', [UserVerifyDocumentController::class, 'update'])->name('verify-document.update');
    Route::post('verify-document-delete-{id}', [UserVerifyDocumentController::class, 'destroy'])->name('verify-document.delete');

    // TODO: Ref Referred Distibution
    Route::get('ref-dest', [referredDistibuttion::class, 'index'])->name('ref-dest');
    Route::post('ref-dest-store', [referredDistibuttion::class, 'dest_store'])->name('ref-dest-store');
    Route::get('ref-dest-delete/{slug}', [referredDistibuttion::class, 'dest_delete'])->name('ref-dest-delete');

    // TODO: Job Category Routes
    Route::get('job-category', [CategoryController::class, 'index'])->name('job-category');
    Route::post('job-category-store', [CategoryController::class, 'store'])->name('job-category.store');
    Route::post('job-category-update-{id}', [CategoryController::class, 'update'])->name('job-category.update');

    Route::get('job-sub-category', [SubCategoryController::class, 'index'])->name('job-sub-category');
    Route::post('job-sub-category-store', [SubCategoryController::class, 'store'])->name('job-sub-category.store');
    Route::post('job-sub-category-update-{id}', [SubCategoryController::class, 'update'])->name('job-sub-category.update');

    // TODO: Boost Charge Routes
    Route::get('boost-charge', [BoostChargeController::class, 'index'])->name('boost-charge');
    Route::post('boost-charge-store', [BoostChargeController::class, 'store'])->name('boost-charge.store');
    Route::post('boost-charge-update-{id}', [BoostChargeController::class, 'update'])->name('boost-charge.update');
    Route::get('boost-charge-delete-{id}', [BoostChargeController::class, 'destroy'])->name('boost-charge.delete');

    // TODO: Boost Category Routes
    Route::get('boost-category', [BoostCategoryController::class, 'index'])->name('boost-category');
    Route::post('boost-category-store', [BoostCategoryController::class, 'store'])->name('boost-category.store');
    Route::post('boost-category-update-{id}', [BoostCategoryController::class, 'update'])->name('boost-category.update');

    Route::get('boost-sub-category', [BoostSubCategoryController::class, 'index'])->name('boost-sub-category');
    Route::post('boost-sub-category-store', [BoostSubCategoryController::class, 'store'])->name('boost-sub-category.store');
    Route::post('boost-sub-category-update-{id}', [BoostSubCategoryController::class, 'update'])->name('boost-sub-category.update');

    Route::get('boost-package', [UserBoostPackageController::class, 'index'])->name('boost-package');
    Route::get('boost-package-process/{id}', [UserBoostPackageController::class, 'process'])->name('boost-package-process');
    Route::get('boost-package-inprocess/{id}', [UserBoostPackageController::class, 'inprocess'])->name('boost-package-inprocess');
    Route::get('boost-package-complete/{id}', [UserBoostPackageController::class, 'complete'])->name('boost-package-complete');
    Route::get('boost-package-delete/{id}', [UserBoostPackageController::class, 'destroy'])->name('boost-package-delete');
    Route::post('boost-package-reject/{id}', [UserBoostPackageController::class, 'reject'])->name('boost-package-reject');

    // TODO: continent routes
    Route::get('continent', [ContinentController::class, 'index'])->name('continent');
    Route::post('continent-store', [ContinentController::class, 'store'])->name('continent.store');
    Route::post('continent-update-{id}', [ContinentController::class, 'update'])->name('continent.update');
    
    // TODO: Country routes
    Route::get('country', [CountryController::class, 'index'])->name('country');
    Route::post('country-store', [CountryController::class, 'store'])->name('country.store');
    Route::post('country-update-{id}', [CountryController::class, 'update'])->name('country.update');

    Route::get('zone', [LocationZoneController::class, 'index'])->name('zone');
    Route::post('zone-store', [LocationZoneController::class, 'store'])->name('zone.store');
    Route::post('zone-update-{id}', [LocationZoneController::class, 'update'])->name('zone.update');

    Route::get('zone-country/{id}', [LocationZoneCountryController::class, 'index'])->name('zone-country');
    Route::post('zone-country-store', [LocationZoneCountryController::class, 'store'])->name('zone-country.store');
    Route::post('zone-country-delete-{id}', [LocationZoneCountryController::class, 'destroy'])->name('zone-country.delete');

    // TODO: Lottery Route
    Route::get('lottery', [LotteryController::class, 'index'])->name('lottery');
    Route::post('lottery-store', [LotteryController::class, 'store'])->name('lottery.store');
    Route::post('lottery-update-{id}', [LotteryController::class, 'update'])->name('lottery.update');
    Route::get('lottery-delete-{id}', [LotteryController::class, 'destroy'])->name('lottery.delete');
    Route::get('lottery-active-{id}', [LotteryController::class, 'lottery_active'])->name('lottery.active');
    Route::get('lottery-deactive-{id}', [LotteryController::class, 'lottery_deactive'])->name('lottery.deactive');
    Route::get('lottery-bought-user-{id}', [LotteryController::class, 'lottery_bought_user'])->name('lottery-bought-user');

    // TODO: Headline routes
    Route::get('headline', [HeadlineController::class, 'index'])->name('headline');
    Route::post('headline-store', [HeadlineController::class, 'store'])->name('headline.store');
    Route::post('headline-delete-{id}', [HeadlineController::class, 'destroy'])->name('headline.delete');

    // TODO: Accept Task Headline routes
    Route::get('accept-task-headline', [AcceptTaskHeadlineController::class, 'index'])->name('accept-task-headline');
    Route::post('accept-task-headline-store', [AcceptTaskHeadlineController::class, 'store'])->name('accept-task-headline.store');
    Route::post('accept-task-headline-delete-{id}', [AcceptTaskHeadlineController::class, 'destroy'])->name('accept-task-headline.delete');

    // TODO: Complete Task Headline routes
    Route::get('complete-task-headline', [CompleteTaskHeadlineController::class, 'index'])->name('complete-task-headline');
    Route::post('complete-task-headline-store', [CompleteTaskHeadlineController::class, 'store'])->name('complete-task-headline.store');
    Route::post('complete-task-headline-delete-{id}', [CompleteTaskHeadlineController::class, 'destroy'])->name('complete-task-headline.delete');

    // TODO: Deposit Headline routes
    Route::get('deposit-headline', [DepositTaskHeadlineController::class, 'index'])->name('deposit-headline');
    Route::post('deposit-headline-store', [DepositTaskHeadlineController::class, 'store'])->name('deposit-headline.store');
    Route::post('deposit-headline-delete-{id}', [DepositTaskHeadlineController::class, 'destroy'])->name('deposit-headline.delete');


    // TODO: Deposit Document routes
    Route::get('deposit-document', [DepositDocumentController::class, 'index'])->name('deposit-document');
    Route::post('deposit-document-store', [DepositDocumentController::class, 'store'])->name('deposit-document.store');
    Route::post('deposit-document-delete-{id}', [DepositDocumentController::class, 'destroy'])->name('deposit-document.delete');

    // TODO: Withdraw Headline routes
    Route::get('withdraw-headline', [WithdrawTaskHeadlineController::class, 'index'])->name('withdraw-headline');
    Route::post('withdraw-headline-store', [WithdrawTaskHeadlineController::class, 'store'])->name('withdraw-headline.store');
    Route::post('withdraw-headline-delete-{id}', [WithdrawTaskHeadlineController::class, 'destroy'])->name('withdraw-headline.delete');

    // TODO: Boost Package Headline routes
    Route::get('boost-package-headline', [BoostPackageHeadlineController::class, 'index'])->name('boost-package-headline');
    Route::post('boost-package-headline-store', [BoostPackageHeadlineController::class, 'store'])->name('boost-package-headline.store');
    Route::post('boost-package-headline-delete-{id}', [BoostPackageHeadlineController::class, 'destroy'])->name('boost-package-headline.delete');

    // TODO: Top Deposit User Headline routes
    Route::get('top-deposit-user-headline', [TopDepositUserHeadlineController::class, 'index'])->name('top-deposit-user-headline');
    Route::post('top-deposit-user-headline-store', [TopDepositUserHeadlineController::class, 'store'])->name('top-deposit-user-headline.store');
    Route::post('top-deposit-user-headline-delete-{id}', [TopDepositUserHeadlineController::class, 'destroy'])->name('top-deposit-user-headline.delete');

    // TODO: Top Earning User Headline routes
    Route::get('top-earning-user-headline', [TopEarningUserHeadlineController::class, 'index'])->name('top-earning-user-headline');
    Route::post('top-earning-user-headline-store', [TopEarningUserHeadlineController::class, 'store'])->name('top-earning-user-headline.store');
    Route::post('top-earning-user-headline-delete-{id}', [TopEarningUserHeadlineController::class, 'destroy'])->name('top-earning-user-headline.delete');

    // TODO: Top Referral User Headline routes
    Route::get('top-referral-user-headline', [TopReferralUserHeadlineController::class, 'index'])->name('top-referral-user-headline');
    Route::post('top-referral-user-headline-store', [TopReferralUserHeadlineController::class, 'store'])->name('top-referral-user-headline.store');
    Route::post('top-referral-user-headline-delete-{id}', [TopReferralUserHeadlineController::class, 'destroy'])->name('top-referral-user-headline.delete');


    // TODO: Headline routes
    Route::get('user-message', [UserMessageController::class, 'index'])->name('user-message');
    Route::post('user-message-store', [UserMessageController::class, 'store'])->name('user-message.store');
    Route::post('user-message-delete-{id}', [UserMessageController::class, 'destroy'])->name('user-message.delete');

    // TODO: Welcome Bonus Route
    Route::get('default-setup', [DefaultController::class, 'index'])->name('default-setup');
    Route::post('minimum-deposit/{id}', [DefaultController::class, 'minimum_deposit'])->name('minimum-deposit.update');
    Route::post('withdraw-fee/{id}', [DefaultController::class, 'withdraw_fee'])->name('withdraw-fee.update');
    Route::post('job-fee/{id}', [DefaultController::class, 'job_fee'])->name('job-fee.update');
    Route::post('welcome-bonus-update-{id}', [WelcomeBonusController::class, 'update'])->name('welcome-bonus.update');
    Route::post('dollar-rate-update-{id}', [DollarRateController::class, 'update'])->name('dollar-rate.update');
    Route::post('main-wallet-{id}', [DefaultController::class, 'main_wallet_update'])->name('main-wallet.update');
    Route::post('screenshot-charge-{id}', [DefaultController::class, 'screenshot_charge_update'])->name('screenshot-charge.update');
    Route::post('need-user-verification-{id}', [DefaultController::class, 'need_user_verification_update'])->name('need-user-verification.update');

    // TODO: Client Photo Route
    Route::get('client', [ClientController::class, 'index'])->name('client');
    Route::post('client-store', [ClientController::class, 'store'])->name('client.store');
    Route::get('client-delete-{id}', [ClientController::class, 'destroy'])->name('client.delete');


    // TODO: Website Route
    Route::get('website', [WebsiteController::class, 'index'])->name('website');
    Route::post('website-update-{id}', [WebsiteController::class, 'update'])->name('website.update');
    
    Route::get('mail-configure', [WebsiteController::class, 'mail_configure'])->name('mail-configure');
    Route::post('mail-configure-update-{id}', [WebsiteController::class, 'mail_configure_update'])->name('mail-configure.update');

    // TODO: User Profile Route
    Route::get('profile', [ProfileController::class, 'index'])->name('profile');
    Route::post('profile-update-{id}', [ProfileController::class, 'update'])->name('profile.update');

    // TODO: User Setting Route
    Route::get('setting', [UserSettingController::class, 'index'])->name('setting');
    Route::post('setting-update-{id}', [UserSettingController::class, 'update'])->name('setting.update');
    
    Route::post('/get-sub-category-price', [UserDashboardController::class, 'get_sub_category_price'])->name('get-sub-category-price');
    Route::post('/get-new-task-complete-area', [UserDashboardController::class, 'get_new_task_complete_area'])->name('get-new-task-complete-area');
});

Route::group(['prefix' => 'user', 'as' => 'user.', 'namespace' => 'User', 'middleware' => ['auth', 'user']], function () {
    Route::get('/', [UserDashboardController::class, 'index'])->name('dashboard');
    Route::get('/find-job', [UserDashboardController::class, 'index'])->name('find-job');
    Route::get('/survey-and-offers', [UserDashboardController::class, 'survey_and_offers'])->name('survey-and-offers');
    Route::get('/policy/{slug}', [UserDashboardController::class, 'policy_details'])->name('policy-details');
    Route::get('/job-details/{code}', [UserDashboardController::class, 'job_details'])->name('my-job-details');

    Route::get('/top-deposit-user', [UserDashboardController::class, 'top_deposit_user'])->name('top-deposit-user');
    Route::get('/top-earning-user', [UserDashboardController::class, 'top_earning_user'])->name('top-earning-user');
    Route::get('/top-referral-user', [UserDashboardController::class, 'top_referral_user'])->name('top-referral-user');
    Route::get('/top-job-posted-user', [UserDashboardController::class, 'top_job_posted_user'])->name('top-job-posted-user');
    Route::get('/top-job-worked-user', [UserDashboardController::class, 'top_job_worked_user'])->name('top-job-worked-user');
    Route::get('/user-total-jobs', [UserDashboardController::class, 'userTotalJobs'])->name('user-total-jobs');

    Route::get('/account-instant-verify', [UserDashboardController::class, 'account_instant_verify'])->name('account-instant-verify');
    Route::get('/instant-verify-my-account', [UserDashboardController::class, 'instant_verify_my_account'])->name('instant-verify-my-account');
    Route::post('/account-verify-with-document-store', [UserDashboardController::class, 'account_verify_with_document_store'])->name('account-verify-with-document-store');
    Route::get('/account-verify-with-document-success', [UserDashboardController::class, 'account_verify_with_document_success'])->name('account-verify-with-document-success');
    
    Route::get('premium', [UserDashboardController::class, 'premium'])->name('premium');
    Route::post('active-premium', [UserDashboardController::class, 'active_premium'])->name('active-premium');
    
    // TODO: Spin route
    Route::get('/spin', [UserSpinController::class, 'index'])->name('spin');


    Route::get('/message-list', [UserDashboardController::class, 'message_list'])->name('message-list');
    Route::post('/get-country', [UserDashboardController::class, 'get_country'])->name('get-country');
    Route::post('/get-continent-country', [UserDashboardController::class, 'get_continent_country'])->name('get-continent-country');
    Route::post('/get-sub-category', [UserDashboardController::class, 'get_sub_category'])->name('get-sub-category');
    Route::post('/get-sub-categorys', [UserDashboardController::class, 'get_sub_categorys'])->name('get-sub-categorys');
    Route::post('/get-sub-category-price', [UserDashboardController::class, 'get_sub_category_price'])->name('get-sub-category-price');
    Route::post('/get-new-task-complete-area', [UserDashboardController::class, 'get_new_task_complete_area'])->name('get-new-task-complete-area');

    Route::post('/get-boost-sub-category', [UserDashboardController::class, 'get_boost_sub_category'])->name('get-boost-sub-category');
    Route::post('/get-boost-sub-category-data', [UserDashboardController::class, 'get_boost_sub_category_data'])->name('get-boost-sub-category-data');
    Route::post('/get-boost-sub-category-price', [UserDashboardController::class, 'get_boost_sub_category_price'])->name('get-boost-sub-category-price');

    Route::get('/deposit', [UserDepositCOntroller::class, 'index'])->name('deposit');
    Route::get('/deposit-list', [UserDepositCOntroller::class, 'deposit_list'])->name('deposit-list');
    Route::post('/deposit-account-info', [UserDepositCOntroller::class, 'deposit_account_info'])->name('deposit-account-info');
    Route::post('/deposit-store', [UserDepositCOntroller::class, 'store'])->name('deposit-store');
    Route::get('/balance-transfer', [UserDepositCOntroller::class, 'balance_transfer'])->name('balance-transfer');
    Route::post('/earning-to-deposit', [UserDepositCOntroller::class, 'earning_to_deposit'])->name('earning-to-deposit');
    Route::get('/earning-to-deposit-balance', [UserDepositCOntroller::class, 'earning_to_deposit_balance'])->name('earning-to-deposit-balance');
    Route::get('/instant-deposit', [UserDepositCOntroller::class, 'instant_deposit'])->name('instant-deposit');

    // TODO: Lottery
    Route::get('lottery', [UserLotteryController::class, 'index'])->name('lottery');
    Route::get('lottery-list', [UserLotteryController::class, 'lottery_list'])->name('lottery-list');
    Route::post('/lottery-buy-confirm', [UserLotteryController::class, 'lottery_buy_confirm'])->name('lottery-buy-confirm');

    Route::get('/advertisement', [UserAdvertisementController::class, 'index'])->name('advertisement');
    Route::get('/advertisement-list', [UserAdvertisementController::class, 'advertisement_list'])->name('advertisement-list');
    Route::post('/advertisement-store', [UserAdvertisementController::class, 'store'])->name('advertisement-store');

    Route::get('/withdraw', [UserWithdrawController::class, 'index'])->name('withdraw');
    Route::get('/new-withdraw-request', [UserWithdrawController::class, 'create'])->name('new-withdraw-request');
    Route::post('/withdraw-account-info', [UserWithdrawController::class, 'withdraw_account_info'])->name('withdraw-account-info');
    Route::post('/withdraw-store', [UserWithdrawController::class, 'store'])->name('withdraw-store');
    
    //account upgrade 
      Route::get('/account-upgrade-page', [UserProfileController::class, 'userUpgradePage'])->name('account-upgrade-page');
      Route::get('/account-upgrade', [UserProfileController::class, 'userUpgrade'])->name('account-upgrade');

    // TODO: Job route
    Route::get('/job', [UserJobController::class, 'index'])->name('job');
    Route::get('/job-create', [UserJobController::class, 'create'])->name('job-create');
    Route::post('/job-post', [UserJobController::class, 'store'])->name('job-post');
    Route::get('/job-post-done', [UserJobController::class, 'job_post_done'])->name('job-post-done');
    Route::get('/job-edit/{id}', [UserJobController::class, 'edit'])->name('job-edit');
    Route::post('/job-update/{id}', [UserJobController::class, 'update'])->name('job-update');
    Route::get('/job-delete/{id}', [UserJobController::class, 'destroy'])->name('job-delete');
    Route::post('/get-job-country-wise', [UserJobController::class, 'get_job_country_wise'])->name('get-job-country-wise');
    Route::post('/get-job-category-wise', [UserJobController::class, 'get_job_category_wise'])->name('get-job-category-wise');
    Route::post('/get-regular-job', [UserJobController::class, 'get_regular_job'])->name('get-regular-job');
    Route::post('/get-recent-job', [UserJobController::class, 'get_recent_job'])->name('get-recent-job');
    Route::post('/get-heigh-cost-job', [UserJobController::class, 'get_heigh_cost_job'])->name('get-heigh-cost-job');
    Route::post('/get-load-more-job', [UserJobController::class, 'get_load_more_job'])->name('get-load-more-job');
    Route::post('/job-work-need-update/{id}', [UserJobController::class, 'job_work_need_update'])->name('job-work-need-update');
    Route::post('/job-boosting-update/{id}', [UserJobController::class, 'job_boosting_update'])->name('job-boosting-update');
    Route::get('/pause-job/{id}', [UserJobController::class, 'pause_job'])->name('pause-job');
    Route::get('/start-job/{id}', [UserJobController::class, 'start_job'])->name('start-job');
    Route::post('job-report/{id}', [UserJobController::class, 'job_report'])->name('job-report');
    
   // Ads system 
    Route::get('/ads-create', [UserAdvertisementController::class, 'ads_create'])->name('ads-create');
    Route::post('/ads-store', [UserAdvertisementController::class, 'ads_store'])->name('ads-store');
    
    Route::get('/ads-click_create', [UserAdvertisementController::class, 'click_create'])->name('ads-click_create');
    Route::post('/ads-status-update/{id}', [UserAdvertisementController::class, 'updateStatus']);
    Route::post('/ads-bal_withdraw/{id}', [UserAdvertisementController::class, 'bal_withdraw'])->name('ads.bal_withdraw');
    Route::get('/ads-history/{id}', [UserAdvertisementController::class, 'history'])->name('ads.history');
    Route::get('/ads-history_buyer/{slug}', [UserAdvertisementController::class, 'history_buyer'])->name('ads.history_buyer');


    // TODO: Boost route
    Route::get('/boost', [BoostPackageController::class, 'index'])->name('boost');
    Route::get('/boost-create', [BoostPackageController::class, 'create'])->name('boost-create');
    Route::post('/boost-post', [BoostPackageController::class, 'store'])->name('boost-post');
    Route::get('/boost-edit/{id}', [BoostPackageController::class, 'edit'])->name('boost-edit');
    Route::post('/boost-update/{id}', [BoostPackageController::class, 'update'])->name('boost-update');
    Route::post('/boost-delete/{id}', [BoostPackageController::class, 'destroy'])->name('boost-delete');

    // TODO: Job route
    Route::get('/worked-job', [UserJobWorkController::class, 'index'])->name('worked-job');
    Route::get('/complete-worked-job', [UserJobWorkController::class, 'complete'])->name('complete-worked-job');
    Route::get('/job-working-proves/{code}', [UserJobWorkController::class, 'job_working_proves'])->name('job-working-proves');
    Route::get('/all-satisfied-job-woked/{job_id}', [UserJobWorkController::class, 'all_satisfied_of_job'])->name('all-satisfied-job-woked');
    Route::get('/all-satisfied-woked', [UserJobWorkController::class, 'all_satisfied'])->name('all-satisfied-woked');
    Route::post('/report-this-job', [UserJobWorkController::class, 'report_this_job'])->name('report-this-job');
    Route::post('/job-work-post', [UserJobWorkController::class, 'store'])->name('job-work-post');
    Route::post('/resubmit-job-work', [UserJobWorkController::class, 'resubmit_job_work'])->name('resubmit-job-work');
    Route::get('/job-work-confirm', [UserJobWorkController::class, 'job_work_confirm'])->name('job-work-confirm');
    // Route::get('job-work-delete/{id}', [UserJobWorkController::class, 'destroy'])->name('job-work-delete');
    Route::get('job-hide/{id}', [UserJobWorkController::class, 'job_hide'])->name('job-hide');
    Route::get('job-work-approve/{id}', [UserJobWorkController::class, 'job_work_approve'])->name('job-work-approve');
    Route::post('job-work-reject/{id}', [UserJobWorkController::class, 'job_work_reject'])->name('job-work-reject');
    Route::post('job-work-report/{id}', [UserJobWorkController::class, 'job_work_report'])->name('job-work-report');
    Route::post('job-work-resume/{id}', [UserJobWorkController::class, 'job_work_resume'])->name('job-work-resume');
    
    Route::post('job-work-rate/{id}', [UserJobWorkController::class, 'job_work_rate'])->name('job-work-rate');
    Route::post('job-work-give-tips/{id}', [UserJobWorkController::class, 'job_work_give_tips'])->name('job-work-give-tips');
    Route::post('job-work-report-to-job-woner/{id}', [UserJobWorkController::class, 'job_work_report_to_job_woner'])->name('job-work-report-to-job-woner');
    Route::post('job-task-report/{id}', [UserJobWorkController::class, 'job_task_report'])->name('job-task-report');

    // TODO: User Profile Route
    Route::get('profile', [UserProfileController::class, 'index'])->name('profile');
    Route::get('user-profile/{id}', [UserProfileController::class, 'user_profile'])->name('user-profile');
    Route::get('profile/{user}', [UserProfileController::class, 'show'])->name('user.profile');

    Route::get('manage-profile', [UserProfileController::class, 'edit'])->name('manage-profile');
    Route::post('profile-update-{id}', [UserProfileController::class, 'update'])->name('profile.update');
    Route::post('add-spin-mark-to-earning', [UserProfileController::class, 'add_spin_mark_to_earning'])->name('add-spin-mark-to-earning');
    
    Route::get('profile-verify-data', [UserProfileController::class, 'profile_verify_data'])->name('profile-verify-data');
    Route::post('profile-verify-data-update', [UserProfileController::class, 'profile_verify_data_update'])->name('profile-verify-data.update');
    

    // TODO: User Referral Route
    Route::get('referral', [UserReferralController::class, 'index'])->name('referral');
    Route::get('referral-user', [UserReferralController::class, 'view_list'])->name('referral-user');
});
